/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.items.components.AItemPack;
import minecrafttransportsimulator.items.instances.ItemBullet;
import minecrafttransportsimulator.jsondefs.JSONBullet;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packloading.PackMaterialComponent;
import minecrafttransportsimulator.systems.ConfigSystem;

public interface IInventoryProvider {
    default public double getInventoryMass() {
        Map<String, Double> heavyItems = ConfigSystem.settings.general.itemWeights.weights;
        double currentMass = 0.0;
        for (int i = 0; i < this.getSize(); ++i) {
            IWrapperItemStack stack = this.getStack(i);
            double weightMultiplier = 1.0;
            for (String heavyItemName : heavyItems.keySet()) {
                if (!InterfaceManager.coreInterface.getStackItemName(stack).contains(heavyItemName)) continue;
                weightMultiplier = heavyItems.get(heavyItemName);
                break;
            }
            currentMass += (double)(5.0f * (float)stack.getSize() / (float)stack.getMaxSize()) * weightMultiplier;
        }
        return currentMass;
    }

    public int getSize();

    default public int getStackSize() {
        return 64;
    }

    default public int getStackCount() {
        int count = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getStack(i).isEmpty()) continue;
            ++count;
        }
        return count;
    }

    default public int getItemCount() {
        int count = 0;
        for (int i = 0; i < this.getSize(); ++i) {
            count += this.getStack(i).getSize();
        }
        return count;
    }

    default public boolean isStackValid(IWrapperItemStack stackToCheck, int index) {
        return true;
    }

    public IWrapperItemStack getStack(int var1);

    public void setStack(IWrapperItemStack var1, int var2);

    default public boolean addStack(IWrapperItemStack stackToAdd, int qty, boolean doAdd) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.isStackValid(stackToAdd, i)) continue;
            IWrapperItemStack stack = this.getStack(i);
            int amountToAdd = 0;
            if (stack.isEmpty()) {
                amountToAdd = this.getStackSize();
                if (amountToAdd > qty) {
                    amountToAdd = qty;
                }
                qty -= amountToAdd;
                if (!doAdd) continue;
                this.setStack(stackToAdd.split(amountToAdd), i);
                continue;
            }
            if (!stackToAdd.isCompleteMatch(stack) || (amountToAdd = Math.min(this.getStackSize(), stack.getMaxSize()) - stack.getSize()) <= 0) continue;
            if (amountToAdd > qty) {
                amountToAdd = qty;
            }
            qty -= amountToAdd;
            if (!doAdd) continue;
            stack.add(amountToAdd);
            this.setStack(stack, i);
            stackToAdd.add(-amountToAdd);
        }
        return qty == 0;
    }

    default public boolean addStack(IWrapperItemStack stackToAdd) {
        return this.addStack(stackToAdd, stackToAdd.getSize(), true);
    }

    default public boolean removeStack(IWrapperItemStack referenceStack, int qtyToRemove, boolean checkNBT) {
        IWrapperItemStack stack;
        int i;
        int qtyFound = 0;
        for (i = 0; i < this.getSize(); ++i) {
            stack = this.getStack(i);
            if (!InterfaceManager.coreInterface.isOredictMatch(stack, referenceStack) || checkNBT && !IWrapperNBT.isDataEqual(referenceStack.getData(), stack.getData())) continue;
            qtyFound += stack.getSize();
        }
        if (qtyFound >= qtyToRemove) {
            qtyToRemove = -qtyToRemove;
            for (i = 0; i < this.getSize(); ++i) {
                stack = this.getStack(i);
                if (!InterfaceManager.coreInterface.isOredictMatch(stack, referenceStack) || checkNBT && !IWrapperNBT.isDataEqual(referenceStack.getData(), stack.getData())) continue;
                qtyToRemove = stack.add(qtyToRemove);
                this.setStack(stack, i);
            }
        }
        return qtyToRemove == 0;
    }

    default public int getSlotForStack(IWrapperItemStack stackToFind) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (!InterfaceManager.coreInterface.isOredictMatch(this.getStack(i), stackToFind)) continue;
            return i;
        }
        return -1;
    }

    default public boolean addToSlot(int index, int qty) {
        IWrapperItemStack stack = this.getStack(index);
        if (stack.getSize() + qty < stack.getMaxSize()) {
            stack.add(qty);
            this.setStack(stack, index);
            return true;
        }
        return false;
    }

    default public boolean removeFromSlot(int index, int qty) {
        IWrapperItemStack stack = this.getStack(index);
        if (stack.getSize() - qty >= 0) {
            stack.add(-qty);
            this.setStack(stack, index);
            return true;
        }
        return false;
    }

    default public boolean hasMaterials(List<PackMaterialComponent> materials) {
        for (PackMaterialComponent material : materials) {
            int requiredMaterialCount = material.qty;
            for (IWrapperItemStack materialStack : material.possibleItems) {
                for (int i = 0; i < this.getSize(); ++i) {
                    IWrapperItemStack testStack = this.getStack(i);
                    if (!InterfaceManager.coreInterface.isOredictMatch(testStack, materialStack)) continue;
                    requiredMaterialCount -= testStack.getSize();
                }
            }
            if (requiredMaterialCount <= 0) continue;
            return false;
        }
        return true;
    }

    default public boolean hasSpecificMaterial(AItemPack<?> item, int recipeIndex, int index, boolean includeMain, boolean includeSub, boolean forRepair, boolean includeRepair) {
        PackMaterialComponent material = PackMaterialComponent.parseFromJSON(item, recipeIndex, includeMain, includeSub, forRepair, includeRepair).get(index);
        int requiredMaterialCount = material.qty;
        for (IWrapperItemStack materialStack : material.possibleItems) {
            for (int i = 0; i < this.getSize(); ++i) {
                IWrapperItemStack testStack = this.getStack(i);
                if (!InterfaceManager.coreInterface.isOredictMatch(testStack, materialStack)) continue;
                requiredMaterialCount -= testStack.getSize();
            }
        }
        return requiredMaterialCount > 0;
    }

    default public void removeMaterials(List<PackMaterialComponent> materials) {
        for (PackMaterialComponent material : materials) {
            int requiredMaterialCount = material.qty;
            block1: for (IWrapperItemStack materialStack : material.possibleItems) {
                for (int i = 0; i < this.getSize(); ++i) {
                    IWrapperItemStack testStack = this.getStack(i);
                    if (InterfaceManager.coreInterface.isOredictMatch(testStack, materialStack)) {
                        int amountToRemove = requiredMaterialCount;
                        if (testStack.getSize() < amountToRemove) {
                            amountToRemove = testStack.getSize();
                        }
                        this.removeStack(testStack, amountToRemove, false);
                        requiredMaterialCount -= amountToRemove;
                    }
                    if (requiredMaterialCount == 0) continue block1;
                }
            }
        }
    }

    default public int getRepairIndex(AItemPack<?> item) {
        for (int i = 0; i < this.getSize(); ++i) {
            IWrapperItemStack testStack = this.getStack(i);
            if (!item.equals(testStack.getItem()) || !((AItemPack)testStack.getItem()).needsRepair(testStack.getData())) continue;
            return i;
        }
        return -1;
    }

    default public double getExplosiveness() {
        double explosivePower = 0.0;
        for (int i = 0; i < this.getSize(); ++i) {
            IWrapperItemStack stack = this.getStack(i);
            AItemBase item = stack.getItem();
            if (!(item instanceof ItemBullet)) continue;
            ItemBullet bullet = (ItemBullet)item;
            if (((JSONBullet)bullet.definition).bullet == null) continue;
            double shellBlastStrength = 2.5E-7 * (double)(((JSONBullet)bullet.definition).bullet.diameter * ((JSONBullet)bullet.definition).bullet.caseLength);
            if (((JSONBullet)bullet.definition).bullet.blastStrength > 0.0f) {
                shellBlastStrength += 0.1 * (double)((JSONBullet)bullet.definition).bullet.blastStrength;
            }
            explosivePower = 0.5 * shellBlastStrength * (double)((JSONBullet)bullet.definition).bullet.quantity * (double)stack.getSize();
        }
        return explosivePower;
    }
}

